% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_mark_message_read}
\alias{whapi_mark_message_read}
\title{Mark a WhatsApp message as READ (Whapi.Cloud)}
\usage{
whapi_mark_message_read(
  message_id,
  token = Sys.getenv("WHAPI_TOKEN", unset = ""),
  timeout = 30,
  verbose = TRUE
)
}
\arguments{
\item{message_id}{Character(1). Message ID (WAMID) to be marked as read.}

\item{token}{Character(1). Bearer token. Default: \code{Sys.getenv("WHAPI_TOKEN")}.}

\item{timeout}{Numeric(1). Timeout (s). Default: 30.}

\item{verbose}{Logical(1). Show logs via \pkg{cli}? Default: \code{TRUE}.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{id}        - the provided \code{message_id};
\item \code{status}    - \code{"read"} when \code{success=TRUE}, \code{"error"} otherwise;
\item \code{success}   - logical value returned by the endpoint;
\item \code{resp}      - raw response (list).
}
}
\description{
Marks a message as \strong{read} using \code{PUT /messages/{MessageID}}.
This endpoint returns only a minimalistic ACK in the body:
\code{{"success": true | false}}.
}
\examples{
\dontrun{
 Sys.setenv(WHAPI_TOKEN = "your_token_here")
 whapi_mark_message_read("PsqXn5SAD5v7HRA-wHqB9tMeGQ")
}
}
