% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_build_servicos_sections}
\alias{whapi_build_servicos_sections}
\title{Build Whapi service sections from a tibble (with \code{section} column)}
\usage{
whapi_build_servicos_sections(tbl, section_order = NULL)
}
\arguments{
\item{tbl}{A tibble/data.frame containing at least:
\itemize{
\item \code{section}   (chr): section name
\item \code{id}        (chr): unique identifier (e.g., \code{"ap1"}, \code{"r2"}, \code{"os3"})
\item \code{title}     (chr): display title (can include emoji)
\item \code{descricao} (chr): short description of the service
}}

\item{section_order}{Character vector defining desired order (and subset) of sections.
If \code{NULL}, all sections are included in alphabetical order.}
}
\value{
A list of sections, where each section is a list with:
\itemize{
\item \code{title}: section title
\item \code{rows}: a list of rows, each being a list with \code{id}, \code{title}, and \code{description}
}
}
\description{
Converts a tibble of services (with columns \code{id}, \code{title}, \code{description}, and \code{section})
into a nested list of \strong{sections/rows} in the format expected by Whapi interactive
messages.
}
\details{
\itemize{
\item If \code{section_order = NULL}, all sections are included, ordered alphabetically.
\item If \code{section_order} is provided, it acts as both:
\itemize{
\item a \strong{filter}: only sections listed will be included,
\item and an \strong{order}: sections appear in the same order as in \code{section_order}.
}
}

Within each section, rows are ordered by the numeric part of \code{id}
(via \code{readr::parse_number(id)}).
}
\examples{
de_para_servicos <- tibble::tibble(
  section   = c("Outros Servicos","Renovacoes","Anuencia Previa"),
  id        = c("os2","r4","ap1"),
  title     = c("Consulta Previa",
                "Renovacao de Consulta Previa",
                "Desmembramento"),
  descricao = c("Initial analysis...","Renewal...","Technical authorization...")
)

# All sections (alphabetical)
whapi_build_servicos_sections(de_para_servicos)

# Custom order and filter
whapi_build_servicos_sections(
  de_para_servicos,
  section_order = c("Anuencia Previa","Outros Servicos")
)

}
