% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/security.R
\name{sanitize_file_path}
\alias{sanitize_file_path}
\title{Sanitize file path input}
\usage{
sanitize_file_path(file_path, allow_relative = FALSE)
}
\arguments{
\item{file_path}{Character string representing a file path}

\item{allow_relative}{Logical. Whether to allow relative paths (default: FALSE)}
}
\value{
Sanitized file path or throws error if invalid
}
\description{
Validates and sanitizes file paths to prevent directory traversal attacks
and ensure safe file operations.
}
\seealso{
Other security: 
\code{\link{is_api_key_configured}()},
\code{\link{sanitize_domain}()},
\code{\link{sanitize_hash}()},
\code{\link{sanitize_ip}()},
\code{\link{sanitize_url}()},
\code{\link{security-utilities}}
}
\concept{security}
\keyword{internal}
