% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{vangogh_palette}
\alias{vangogh_palette}
\title{A Van Gogh color palette generator.}
\usage{
vangogh_palette(name, n, type = c("discrete", "continuous"))
}
\arguments{
\item{name}{Name of desired palette. Choices are:
\code{StarryNight}, \code{StarryRhone},  \code{SelfPortrait},
\code{CafeTerrace}, \code{Eglise},  \code{Irises},
\code{SunflowersMunich},  \code{SunflowersLondon},  \code{Rest} ,\code{Bedroom} ,
\code{CafeDeNuit}, \code{Chaise}, \code{Shoes}, \code{Landscape},
\code{Cypresses}}

\item{n}{Number of colors desired. All palettes have a standard of 5 colors.
If omitted, uses all colors.}

\item{type}{Either "continuous" or "discrete".
Use "continuous" to automatically interpolate between colours.
@importFrom graphics rgb rect par image text}
}
\value{
A vector of colors.
}
\description{
These are some color palettes from a selection of Vincent van Gogh's paintings.
}
\examples{
vangogh_palette("StarryNight")
vangogh_palette("SelfPortrait")
vangogh_palette("Cypresses")
vangogh_palette("Cypresses", 3)

# If you want a continous paletted based on the colors already found in the preset
# palettes, you can interpolate between existing colours accordingly.
pal <- vangogh_palette(21, name = "StarryRhone", type = "continuous")
}
\keyword{colors}
