% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ate_assessment.R
\name{ate_assessment}
\alias{ate_assessment}
\title{Assess Analytical Performance Against Allowable Total Error}
\usage{
ate_assessment(
  bias,
  cv,
  tea,
  allowable_bias = NULL,
  allowable_cv = NULL,
  k = 1.65
)
}
\arguments{
\item{bias}{Numeric. Observed bias (systematic error), expressed as a
percentage.}

\item{cv}{Numeric. Observed coefficient of variation (imprecision),
expressed as a percentage.}

\item{tea}{Numeric. Total allowable error specification. Can be provided
directly or will be calculated if \code{allowable_bias} and \code{allowable_cv}
are provided with \code{k}.}

\item{allowable_bias}{Numeric. Allowable bias specification (optional).
If provided, enables individual bias assessment.}

\item{allowable_cv}{Numeric. Allowable imprecision specification (optional).
If provided, enables individual CV assessment.}

\item{k}{Numeric. Coverage factor for TEa calculation when using component
specifications (default: 1.65).}
}
\value{
An object of class \code{c("ate_assessment", "valytics_ate", "valytics_result")},
which is a list containing:

\describe{
\item{assessment}{List with pass/fail results:
\itemize{
\item \code{bias_acceptable}: Logical; TRUE if |bias| <= allowable_bias
\item \code{cv_acceptable}: Logical; TRUE if cv <= allowable_cv
\item \code{tea_acceptable}: Logical; TRUE if observed TE <= TEa
\item \code{overall}: Logical; TRUE if method meets specifications
}
}
\item{observed}{List with observed performance:
\itemize{
\item \code{bias}: Observed bias
\item \code{cv}: Observed CV
\item \code{te}: Observed total error (k * CV + |Bias|)
}
}
\item{specifications}{List with allowable specifications:
\itemize{
\item \code{allowable_bias}: Allowable bias (or NULL)
\item \code{allowable_cv}: Allowable CV (or NULL)
\item \code{tea}: Total allowable error
}
}
\item{sigma}{List with sigma metric results:
\itemize{
\item \code{value}: Sigma metric value
\item \code{category}: Performance category
}
}
\item{settings}{List with settings:
\itemize{
\item \code{k}: Coverage factor used
}
}
}
}
\description{
Evaluates observed analytical performance (bias and imprecision) against
allowable total error specifications. Provides pass/fail assessment for
individual components and overall method acceptability, along with the
sigma metric.
}
\details{
The assessment evaluates method performance at multiple levels:

\strong{Component Assessment} (if specifications provided):
\itemize{
\item Bias: Pass if |observed bias| <= allowable bias
\item CV: Pass if observed CV <= allowable CV
}

\strong{Total Error Assessment}:
\itemize{
\item Observed TE = k * CV + |Bias| (linear model)
\item Pass if observed TE <= TEa
}

\strong{Sigma Metric}:
\itemize{
\item Sigma = (TEa - |Bias|) / CV
\item Provides quality rating from "World Class" to "Unacceptable"
}
}
\section{Overall Assessment}{

The overall assessment is determined as follows:
\itemize{
\item If only TEa is provided: based on total error assessment
\item If component specs provided: all components must pass
\item Sigma >= 3 is generally considered minimum acceptable
}
}

\examples{
# Basic assessment with TEa only
assess <- ate_assessment(bias = 1.5, cv = 2.5, tea = 10)
assess

# Assessment with all component specifications
assess_full <- ate_assessment(
  bias = 1.5,
  cv = 2.5,
  tea = 10,
  allowable_bias = 3.0,
  allowable_cv = 4.0
)
assess_full

# Using specifications from ate_from_bv()
specs <- ate_from_bv(cvi = 5.6, cvg = 7.5)
assess <- ate_assessment(
  bias = 1.5,
  cv = 2.5,
  tea = specs$specifications$tea,
  allowable_bias = specs$specifications$allowable_bias,
  allowable_cv = specs$specifications$allowable_cv
)
summary(assess)

# Check if method passes
assess$assessment$overall

}
\references{
Westgard JO (2008). \emph{Basic Method Validation} (3rd ed.).
Westgard QC, Inc.

Fraser CG (2001). \emph{Biological Variation: From Principles to Practice}.
AACC Press.
}
\seealso{
\code{\link[=ate_from_bv]{ate_from_bv()}} for calculating specifications from biological variation,
\code{\link[=sigma_metric]{sigma_metric()}} for sigma calculation details
}
