% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural_breaks.R
\name{interpret_break_tests}
\alias{interpret_break_tests}
\title{Interpret Break Test Results}
\usage{
interpret_break_tests(break_results, alpha = 0.05)
}
\arguments{
\item{break_results}{Result from test_structural_breaks.}

\item{alpha}{Significance level. Default 0.05.}
}
\value{
Character string with interpretation.
}
\description{
Provides textual interpretation of structural break tests.
}
\examples{
\donttest{
if (requireNamespace("strucchange", quietly = TRUE)) {
  set.seed(123)
  years <- 1980:2020
  panel <- data.frame(
    year = rep(years, 5),
    sector = rep(LETTERS[1:5], each = length(years)),
    log_direct = rnorm(length(years) * 5, 5, 0.5),
    log_production = rnorm(length(years) * 5, 5, 0.5)
  )

  break_tests <- test_structural_breaks(panel)
  interpretation <- interpret_break_tests(break_tests)
  cat(interpretation)
}
}

}
