% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{fetch_vald_metadata}
\alias{fetch_vald_metadata}
\title{Retrieve Athlete Profiles and Group Assignments}
\usage{
fetch_vald_metadata(
  client_id,
  client_secret,
  tenant_id,
  region = "aue",
  verbose = TRUE
)
}
\arguments{
\item{client_id}{Character. Your VALD API client ID.}

\item{client_secret}{Character. Your VALD API client secret.}

\item{tenant_id}{Character. Your VALD tenant ID.}

\item{region}{Character. VALD region code (e.g., "aue" for Australia East).
Default is "aue".}

\item{verbose}{Logical. If TRUE, prints progress messages. Default is TRUE.}
}
\value{
A list containing two data frames:
  \describe{
    \item{profiles}{Complete athlete profile data}
    \item{groups}{Group/team membership data}
  }
}
\description{
Authenticates with VALD API using OAuth2 client credentials flow and retrieves
complete athlete profile and group membership data. This function handles
token management, pagination, and robust JSON parsing.
}
\details{
Fetch VALD Metadata via OAuth2
}
\examples{
\donttest{
if (FALSE) {
  metadata <- fetch_vald_metadata(
    client_id = "your_client_id",
    client_secret = "your_client_secret",
    tenant_id = "your_tenant_id"
  )

  profiles <- metadata$profiles
  groups <- metadata$groups
}
}
}
