% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coh_match_iterate.R
\name{iterate_match}
\alias{iterate_match}
\title{Iterate Match}
\usage{
iterate_match(
  all,
  matched,
  adjusted,
  outcome_date_col,
  censoring_date_col,
  immunization_date_col,
  vacc_status_col,
  vaccinated_status,
  unvaccinated_status,
  exact,
  nearest,
  start_cohort,
  end_cohort
)
}
\arguments{
\item{all}{\code{data.frame} with the entire cohort.}

\item{matched}{\code{data.frame} with the matched cohort.}

\item{adjusted}{\code{data.frame} with the adjusted cohort to calculate
removed cases. Default is NULL, which returns 0.}

\item{outcome_date_col}{Name of the column that contains the outcome dates.}

\item{censoring_date_col}{Name of the column that contains the censoring
date.}

\item{immunization_date_col}{Name of the column that contains the
immunization date to set the beginning of the follow-up period
(\code{t0_follow_up}).}

\item{vacc_status_col}{Name of the column containing the vaccination.}

\item{vaccinated_status}{Status assigned to the vaccinated population.}

\item{unvaccinated_status}{Status assigned to the unvaccinated population.}

\item{exact}{Name(s) of column(s) for \code{exact} matching}

\item{nearest}{Named vector with name(s) of column(s) for \code{nearest} matching
and caliper(s) for each variable (e.g., \code{nearest = c("characteristic1" = n1, "characteristic2" = n2)}, where \code{n1} and \code{n2} are the calipers).}

\item{start_cohort}{Start date of the study.}

\item{end_cohort}{End date of the study.}
}
\value{
\code{data.frame} with adjusted pairs after iterating.
}
\description{
This function iterates to re-match registers that were
removed after adjusting exposure times. To avoid generating the
same pairs already removed, each iteration is split in two steps,
one for the removed vaccinated population and the other for the
unvaccinated. A \code{tryCatch} validation handles errors when no matches
can be generated due to the lack of treated or untreated individuals.
The threshold for the maximum number of iterations is the total
removed population for the first iteration. The algorithm iterates
until no new adjusted pairs are generated or the maximum number of
iterations is reached.
}
\keyword{internal}
