% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_pca.R
\name{uplot_pca}
\alias{uplot_pca}
\title{uplot_pca}
\usage{
uplot_pca(
  mfd,
  grp,
  int_col = "norm_int",
  palname = "viridis",
  col_bar = TRUE,
  ...
)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{grp}{Character vector. Names of columns (e.g., sample or file identifiers)
used to aggregate results.}

\item{int_col}{Character. The name of the column that contains the intensity values
to be used (e.g. for clustering or color coding). Default usually is "norm_int" for normalized intensity values.}

\item{palname}{Color palette name for f_colorz() (viridis, magma, plasma, etc.).}

\item{col_bar}{Logical. If \code{TRUE}, adds a color legend (default is \code{TRUE}).}

\item{...}{Additional arguments passed to methods.}
}
\value{
A list containing:
\item{pca}{The PCA model object (class \code{prcomp}).}
\item{t_score}{A data table of PCA scores (principal component values for each sample).}
\item{fig_vk}{A Van Krevelen plot projected with PC1 values.}
\item{fig_pca}{A scatter plot of the first two principal components (PC1 vs PC2).}
\item{mfd}{The input data table, augmented with principal component values.}
}
\description{
This function performs Principal Component Analysis (PCA) on a dataset, and visualizes the results in various ways, including a scatter plot of the first two principal components (PC1 vs PC2) and a Van Krevelen plot projected using PC1 values. The PCA is performed on the molecular formula data, aggregated by a grouping variable, and handles cases where columns exhibit zero variance (which cannot be included in PCA).
}
\details{
Principal Component Analysis (PCA) Plotting
}
\note{
The function uses \code{prcomp} for PCA and \code{uplot_vk} for the Van Krevelen plot.
}
\seealso{
\code{\link{uplot_vk}} for the Van Krevelen plot function.

Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
