% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{remove_empty_columns}
\alias{remove_empty_columns}
\title{Remove empty columns}
\usage{
remove_empty_columns(df, excl_cols = NULL, ...)
}
\arguments{
\item{df}{A \code{data.table} from which empty columns should be removed.}

\item{excl_cols}{Optional character vector of column names that must be preserved,
even if all values in those columns are missing.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A \code{data.table} containing all original non-empty columns, plus any
columns listed in \code{excl_cols}, regardless of whether they are empty.
Columns that contain only \code{NA} values and are \emph{not} explicitly preserved
are removed from the output.
}
\description{
Removes columns that contain only \code{NA} values from a \code{data.table}.
Columns listed in \code{excl_cols} are retained even if they are empty.
}
\examples{
dt <- data.table::data.table(
  c = c(2, 2, 2),
  x = c(NA, NA, NA),
  y = c(NA, NA, NA)
)
remove_empty_columns(dt, excl_cols = "y")
}
