% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_distributions.R
\docType{data}
\name{viral_shedding}
\alias{viral_shedding}
\title{COVID-19 Viral shedding data}
\format{
An object of class \code{list} of length 2.
}
\source{
\url{https://static-content.springer.com/esm/art\%3A10.1038\%2Fs41467-020-20568-4/MediaObjects/41467_2020_20568_MOESM4_ESM.xlsx}
}
\usage{
data("viral_shedding")
}
\description{
Data from van Kampen et al, 2019, describing duration of viral shedding
from symptom onset in patients with COVID-19.
}
\details{
\subsection{\code{viral_shedding} named list with 2 items}{

\describe{
\item{ \code{original} (df original*) }{
original description
}
\item{ \code{resampled} (df resampled*) }{
resampled description
}
}
}

\subsection{\verb{df original} dataframe with 690 rows and 4 columns}{

\describe{
\item{ \verb{duration of symptoms in days} (dbl) }{
duration of symptoms in days
}
\item{ \verb{RNA copies per mL} (chr) }{
RNA copies per mL
}
\item{ \verb{PRNT titer} (chr) }{
PRNT titer
}
\item{ \verb{virus culture result} (chr) }{
virus culture result
}
}
}

\subsection{\verb{df resampled} dataframe with 2600 rows and 3 columns}{

\describe{
\item{ \code{tau} (int) }{
time from symptom onset to measurement
}
\item{ \code{probability} (dbl) }{
probability of detected viral excretion
}
\item{ \code{boot} (int) }{
a bootstrap identifier
}
}
}
}
\references{
van Kampen, J.J.A., van de Vijver, D.A.M.C., Fraaij, P.L.A. et al. Duration
and key determinants of infectious virus shedding in hospitalized patients
with coronavirus disease-2019 (COVID-19). Nat Commun 12, 267 (2021).
https://doi.org/10.1038/s41467-020-20568-4
}
\concept{datasets}
\keyword{datasets}
