% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_distributions.R
\docType{data}
\name{pcr_test_sensitivity}
\alias{pcr_test_sensitivity}
\title{COVID PCR test sensitivity over time}
\format{
An object of class \code{list} of length 2.
}
\source{
\url{https://pmc.ncbi.nlm.nih.gov/articles/instance/9796165/bin/jiac317_supplementary_data.zip}
}
\usage{
data("pcr_test_sensitivity")
}
\description{
Model output from Binny et al, 2023, describing the sensitivity of COVID PCR tests
over the course of an infection.
}
\details{
\subsection{\code{pcr_test_sensitivity} named list with 2 items}{

\describe{
\item{ \code{modelled} (df modelled*) }{
Original model output from supplementary
}
\item{ \code{resampled} (df resampled*) }{
resampled and reformatted data
}
}
}

\subsection{\verb{df modelled} dataframe with 501 rows and 4 columns}{

\describe{
\item{ \code{days_since_infection} (dbl) }{
days since infection
}
\item{ \code{median} (dbl) }{
median sensitivity
}
\item{ \code{lower_95} (dbl) }{
lower 95\% CI of sensitivity
}
\item{ \code{upper_95} (dbl) }{
upper 95\% CI of sensitivity
}
}
}

\subsection{\verb{df resampled} dataframe with 5100 rows and 3 columns}{

\describe{
\item{ \code{tau} (dbl) }{
days since infection
}
\item{ \code{probability} (dbl) }{
the sensitivity as a probability of detection
}
\item{ \code{boot} (int) }{
a bootstrap identifier
}
}
}
}
\references{
Rachelle N Binny, Patricia Priest, Nigel P French, Matthew Parry, Audrey
Lustig, Shaun C Hendy, Oliver J Maclaren, Kannan M Ridings, Nicholas Steyn,
Giorgia Vattiato, Michael J Plank, Sensitivity of Reverse Transcription
Polymerase Chain Reaction Tests for Severe Acute Respiratory Syndrome
Coronavirus 2 Through Time, The Journal of Infectious Diseases, Volume 227,
Issue 1, 1 January 2023, Pages 9–17, https://doi.org/10.1093/infdis/jiac317
}
\concept{datasets}
\keyword{datasets}
