% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{split_data_counterfactual}
\alias{split_data_counterfactual}
\title{Split Data into Training and Application Datasets}
\usage{
split_data_counterfactual(dt_prepared, application_start, application_end)
}
\arguments{
\item{dt_prepared}{The prepared data table.}

\item{application_start}{The start date(date object) for the application
period of the business-as-usual simulation. This coincides with the start of
the reference window.
Can be created by e.g. lubridate::ymd("20191201")}

\item{application_end}{The end date(date object)  for the application period
of the business-as-usual simulation. This coincides with the end of
the effect window.
Can be created by e.g. lubridate::ymd("20191201")}
}
\value{
A list with two elements:
\describe{
\item{train}{Data outside the application period.}
\item{apply}{Data within the application period.}
}
}
\description{
Splits prepared data into training and application datasets based on
specified date ranges for a business-as-usual scenario. Data before
\code{application_start} and after \code{application_end} is used as training data,
while data within the date range is used for application.
}
\examples{
dt_prepared <- data.table::data.table(
  date = as.Date(c("2023-01-01", "2023-01-05", "2023-01-10")),
  value = c(50, 60, 70)
)
result <- split_data_counterfactual(
  dt_prepared,
  application_start = as.Date("2023-01-03"),
  application_end = as.Date("2023-01-08")
)
print(result$train)
print(result$apply)
}
