% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counterfactual_model.R
\name{run_counterfactual}
\alias{run_counterfactual}
\title{Full counterfactual simulation run}
\usage{
run_counterfactual(
  split_data,
  params,
  detrending_function = "none",
  model_type = "rf",
  alpha = 0.9,
  log_transform = FALSE,
  calc_shaps = FALSE
)
}
\arguments{
\item{split_data}{List of two named dataframes called train and apply}

\item{params}{A list of parameters that define the following:
\describe{
\item{meteo_variables}{A character vector specifying the names of the
meteorological variables used as inputs.}
\item{model}{A list of hyperparameters for training the chosen model. Name of this list
and its parameters depend on the chosen models. See \code{\link[=run_dynamic_regression]{run_dynamic_regression()}},
\code{\link[=run_lightgbm]{run_lightgbm()}}, \code{\link[=run_rf]{run_rf()}} and \code{\link[=run_fnn]{run_fnn()}} functions for details}
}}

\item{detrending_function}{String which defines type of trend to remove.
Options are "linear","quadratic", "exponential", "spline", "none". See \code{\link[=detrend]{detrend()}}
and \code{\link[=retrend_predictions]{retrend_predictions()}} for details.}

\item{model_type}{String to decide which model to use. Current options random
forest "rf", gradient boosted decision trees "lightgbm", "dynamic_regression" and feedforward neural network "fnn"}

\item{alpha}{Confidence level of the prediction interval between 0 and 1.}

\item{log_transform}{If TRUE, uses log transformation during detrending and
retrending. For details see \code{\link[=detrend]{detrend()}} documentation}

\item{calc_shaps}{Boolean value. If TRUE, calculate SHAP values for the
method used and format them so they can be visualised with \code{\link[shapviz:sv_importance]{shapviz:sv_importance()}} and
\code{\link[shapviz:sv_dependence]{shapviz:sv_dependence()}}.
The SHAP values are generated for a subset (or all, depending on the size of the dataset) of the
test data.}
}
\value{
Data frame of predictions and model
}
\description{
Chains detrending, training of a selected model, prediction and retrending together
for ease of use. See documentation of individual functions for details.
}
\examples{
data(mock_env_data)
split_data <- list(
  train = mock_env_data[1:80, ],
  apply = mock_env_data[81:100, ]
)
params <- load_params()
res <- run_counterfactual(split_data, params, detrending_function = "linear")
prediction <- res$retrended_predictions
random_forest_model <- res$model
}
