% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_winsor.R
\name{ts_fil_winsor}
\alias{ts_fil_winsor}
\title{Winsorization of Time Series}
\usage{
ts_fil_winsor()
}
\value{
A \code{ts_fil_winsor} object.
}
\description{
Apply Winsorization to limit extreme values by replacing them
with nearer order statistics, reducing the influence of outliers.
}
\examples{
# Winsorization: cap extreme values to reduce outlier impact
# Load package and example data
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2 * tsd$y[9]  # inject an outlier

# Fit Winsor filter and transform series
filter <- ts_fil_winsor()
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# Plot original vs Winsorized series
plot_ts_pred(y = tsd$y, yadj = y)
}
\references{
\itemize{
\item J. W. Tukey (1962). The future of data analysis. Annals of Mathematical
Statistics. (Winsorization discussed in robust summaries.)
}
}
