% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_frequency.R
\name{generate_frequency}
\alias{generate_frequency}
\title{Generate frequency table}
\usage{
generate_frequency(
  data,
  ...,
  sort_value = TRUE,
  sort_desc = TRUE,
  sort_except = NULL,
  add_total = TRUE,
  add_percent = TRUE,
  add_cumulative = FALSE,
  add_cumulative_percent = FALSE,
  as_proportion = FALSE,
  include_na = TRUE,
  recode_na = "auto",
  position_total = c("bottom", "top"),
  calculate_per_group = TRUE,
  group_separator = " - ",
  group_as_list = FALSE,
  label_as_group_name = TRUE,
  label_stub = NULL,
  label_na = "Not reported",
  label_total = "Total",
  expand_categories = TRUE,
  convert_factor = FALSE,
  collapse_list = FALSE,
  top_n = NULL,
  top_n_only = FALSE,
  metadata = NULL
)
}
\arguments{
\item{data}{A data frame (typically \code{tibble}) containing the variables to summarize.}

\item{...}{One or more unquoted variable names (passed via tidy evaluation) for which to compute frequency tables.}

\item{sort_value}{Logical. If \code{TRUE}, frequency values will be sorted.}

\item{sort_desc}{Logical. If \code{TRUE}, sorts in descending order of frequency. If \code{sort_value = FALSE}, the category is sorted in ascending order.}

\item{sort_except}{Optional character vector. Variables to exclude from sorting.}

\item{add_total}{Logical. If \code{TRUE}, adds a total row or value to the frequency table.}

\item{add_percent}{Logical. If \code{TRUE}, adds percent or proportion values to the table.}

\item{add_cumulative}{Logical. If \code{TRUE}, adds cumulative frequency counts.}

\item{add_cumulative_percent}{Logical. If \code{TRUE}, adds cumulative percentages (or proportions if \code{as_proportion = TRUE}).}

\item{as_proportion}{Logical. If \code{TRUE}, displays proportions instead of percentages (range 0–1).}

\item{include_na}{Logical. If \code{TRUE}, includes missing values in the frequency table.}

\item{recode_na}{Character or \code{NULL}. Value used to replace missing values in labelled vectors; \code{"auto"} will determine a code automatically.}

\item{position_total}{Character. Where to place the total row: \code{"top"} or \code{"bottom"}.}

\item{calculate_per_group}{Logical. If \code{TRUE}, calculates frequencies within groups defined in \code{data} (from \code{group_by()} or existing grouping).}

\item{group_separator}{Character. Separator used when concatenating group values in list output (if \code{group_as_list = TRUE}).}

\item{group_as_list}{Logical. If \code{TRUE}, output is a list of frequency tables for each group combination.}

\item{label_as_group_name}{Logical. If \code{TRUE}, uses variable labels as names in the output list; otherwise, uses variable names.}

\item{label_stub}{Optional character vector used for labeling output tables (e.g., for export or display).}

\item{label_na}{Character. Label to use for missing (\code{NA}) values.}

\item{label_total}{Character. Label used for the total row/category.}

\item{expand_categories}{Logical. If \code{TRUE}, ensures all categories (including those with zero counts) are included in the output.}

\item{convert_factor}{Logical. If \code{TRUE}, converts labelled variables to factors in the output. See also \code{\link[=convert_factor]{convert_factor()}}.}

\item{collapse_list}{Logical. If \code{TRUE} and \code{group_as_list = TRUE}, collapses the list of frequency tables into a single data frame with group identifiers. See also \code{\link[=collapse_list]{collapse_list()}}.}

\item{top_n}{Integer or \code{NULL}. If specified, limits the output to the top \code{n} categories by frequency.}

\item{top_n_only}{Logical. If \code{TRUE} and \code{top_n} is specified, only the top \code{n} categories are included, excluding others.}

\item{metadata}{A named list with optional metadata to attach as attributes, e.g. \code{title}, \code{subtitle}, and \code{source_note}.}
}
\value{
A frequency table (\code{tibble}, possibly nested) or a list of such tables. Additional attributes such as labels, metadata, and grouping information may be attached. The returned object is of class \code{"tsg"}.
}
\description{
Creates frequency tables for one or more categorical variables, optionally grouped by other variables.
The function supports various enhancements such as sorting, totals, percentages, cumulative statistics,
handling of missing values, and label customization. It returns a single table or a list of frequency tables.
}
\examples{
# Using built-in dataset `person_record`


# Basic usage
person_record |>
 generate_frequency(sex)

# Multiple variables
person_record |>
  generate_frequency(sex, age, marital_status)

# Grouping
person_record |>
  dplyr::group_by(sex) |>
  generate_frequency(marital_status)

# Output group as list
person_record |>
  dplyr::group_by(sex) |>
  generate_frequency(marital_status, group_as_list = TRUE)

# Sorting

# default is TRUE
person_record |>
  generate_frequency(age, sort_value = TRUE)

# If FALSE, the output will be sorted by the variable values in ascending order.
person_record |>
  generate_frequency(age, sort_value = FALSE)

# Vignettes for more examples.
}
\seealso{
\code{\link[=generate_crosstab]{generate_crosstab()}}, \code{\link[=generate_output]{generate_output()}}, \code{\link[=rename_label]{rename_label()}}, \code{\link[=remove_label]{remove_label()}}
}
