% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_modifiers.R
\name{add_row_total}
\alias{add_row_total}
\title{Add a row total}
\usage{
add_row_total(
  data,
  position = c("bottom", "top"),
  label_total = "Total",
  fill = "-"
)
}
\arguments{
\item{data}{A data frame, tibble, or \code{tsg} object to which a total row will be added.}

\item{position}{Position to add the total row. Either "bottom" (default) or "top".}

\item{label_total}{Label for the total row in the category column. Default is "Total".}

\item{fill}{Character. Value to fill in for missing numeric columns in the total row. Default is "-".}
}
\value{
The input data frame with an additional row representing the total of numeric columns.
}
\description{
Add a row total
}
\examples{
# Example data frame
df <- data.frame(
 category = c("A", "B", "C"),
 value1 = c(10, 20, 30),
 value2 = c(5, 15, 25)
)

df_with_total <- add_row_total(df)
df_with_total_top <- add_row_total(df, position = "top")

}
