#' Compute the probability mass after truncation. 
#' 
#' Compute the probability for the truncation interval 
#' \eqn{(\mathbf{a}, \mathbf{b})}. 
#' 
#' \code{probntrun} is a S3 generic function of the class 
#'     \code{\link{mtrunmnt}}. Using the multivariate Gaussian quadrature, it
#'     computes the probability of truncation interval 
#'     \eqn{(\mathbf{a}, \mathbf{b})}. 
#' 
#' @param Obj An mtrunmnt object created by the \code{\link{mtrunmnt}}.
#' 
#' @seealso \code{\link{mtrunmnt}}, \code{\link[tmvtnorm]{ptmvnorm}}.
#' 
#' @return a numeric value.
#' 
#' @export
#' 
#' @examples
#' ###  A simple example ####
#' set.seed(123)
#' sigma2e <- 1
#' sigma2a <- 2
#' n <- 5
#' mu <- seq(-1,1, length.out = n)
#' y <- mu + rnorm(1, sd = sqrt(sigma2a)) + rnorm(n, sd = sqrt(sigma2e))
#' a  <- rep(-Inf, n)
#' b  <- rep(Inf, n)
#' a[y >= 0] <- 0
#' b[y <  0] <- 0
#' obj <- mtrunmnt(mu, lower = a, upper = b, Sigmae = sigma2e, D = sigma2a) 
#' probntrun(obj)

probntrun <- function(Obj){
  UseMethod("probntrun")
}
#' @export
probntrun.mtrunmnt <- function(Obj){
  return(Obj$probab)
}

