% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{merge_append}
\alias{merge_append}
\title{Append columns from B to A by keyed join (fast, data.table-based)}
\usage{
merge_append(A, B, by_vars, new_vars, overwrite = TRUE, first_match = TRUE)
}
\arguments{
\item{A}{left table (data.frame or data.table) — rows preserved/order preserved}

\item{B}{right table (data.frame or data.table) — must contain by_vars and new_vars}

\item{by_vars}{character vector of join columns (e.g. c("id","tstart","tstop"))}

\item{new_vars}{character vector of column names from B to append to A}

\item{overwrite}{logical: if TRUE, overwrite any existing columns in A
with same avar names (default TRUE)}

\item{first_match}{logical: if TRUE use first match when B has duplicate keys;
if FALSE, error on duplicates}
}
\value{
If A was a data.frame, returns modified data.frame; if A was
data.table returns invisible(NULL).
}
\description{
A and B may be data.frame or data.table.
\itemize{
\item If A is a data.table it will be modified by reference.
\item If A is a data.frame a modified data.frame is returned.
}
}
