% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_TIC.R
\name{detect_tic}
\alias{detect_tic}
\title{Detect Tumor-Infiltrating T-cell Clusters (TIC)}
\arguments{
\item{sample}{Character. Sample name.}

\item{ldata}{Optional list.}
}
\value{
Modified data frame for the sample (invisibly).
}
\description{
Uses HDBSCAN approximation on T cells outside TLS regions to find TIC.
}
\examples{
data(toy_ldata)
ldata <- detect_TLS("ToySample", k = 30, ldata = toy_ldata)  # Need TLS first
ldata <- detect_tic("ToySample", ldata = ldata)
table(ldata[["ToySample"]]$tcell_cluster_hdbscan)
}
