% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_gaps.R
\name{fill_from_past}
\alias{fill_from_past}
\title{Fill from past values}
\usage{
fill_from_past(dtf, varnames, back = 24)
}
\arguments{
\item{dtf}{data.frame or tibble, first column of name \code{datetime} being
of class datetime and rest of columns being numeric}

\item{varnames}{character or vector of characters,
column names with NA values}

\item{back}{integer, number of indices (rows) to go back and get the filling value}
}
\value{
tibble or data.frame
}
\description{
If back index ( NA index - \code{back}) is lower than zero then the it is filled with the first value of the data frame.
If the value in the back index is also NA, it iterates backwards until finding a non-NA value.
}
\examples{
past_data <- data.frame(
  datetime = as.POSIXct("2024-01-01 00:00:00", tz = "UTC") + 0:3 * 3600,
  consumption = c(1.2, NA, NA, 2.5)
)
fill_from_past(past_data, "consumption", back = 1)

}
