% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invert.R
\name{invert}
\alias{invert}
\alias{invert.recipe}
\title{An S3 method for inverting a step}
\usage{
invert(object, predictions, ...)
}
\arguments{
\item{object}{A recipe after fitting a model}

\item{predictions}{A data frame with .pred}

\item{...}{Other arguments}
}
\value{
A tibble with inverted model-generated values
}
\description{
An S3 method for inverting a step
}
\examples{

data <- tibble::tibble(
  y = rlnorm(n = 1000, meanlog = 0, sdlog = 1),
  x = rnorm(n = 1000)
)

adj <- recipes::recipe(y ~ x, data = data) |>
  recipes::step_BoxCox(recipes::all_outcomes()) |>
  recipes::prep()
  
invert(
  object = adj$steps[[1]], 
  predictions = tibble::tibble(.pred = adj[["template"]][["y"]])
)

}
\concept{postprocessing}
