% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/answer_as_integer.R
\name{answer_as_integer}
\alias{answer_as_integer}
\title{Make LLM answer as an integer (between min and max)}
\usage{
answer_as_integer(
  prompt,
  min = NULL,
  max = NULL,
  add_instruction_to_prompt = TRUE
)
}
\arguments{
\item{prompt}{A single string or a \code{\link[=tidyprompt]{tidyprompt()}} object}

\item{min}{(optional) Minimum value for the integer}

\item{max}{(optional) Maximum value for the integer}

\item{add_instruction_to_prompt}{(optional) Add instruction for replying
as an integer to the prompt text. Set to FALSE for debugging if extractions/validations
are working as expected (without instruction the answer should fail the
validation function, initiating a retry)}
}
\value{
A \code{\link[=tidyprompt]{tidyprompt()}} with an added \code{\link[=prompt_wrap]{prompt_wrap()}} which
will ensure that the LLM response is an integer.
}
\description{
Make LLM answer as an integer (between min and max)
}
\examples{
\dontrun{
  "What is 5 + 5?" |>
    answer_as_integer() |>
    send_prompt()
  # --- Sending request to LLM provider (llama3.1:8b): ---
  #   What is 5 + 5?
  #
  #   You must answer with only an integer (use no other characters).
  # --- Receiving response from LLM provider: ---
  #   10
  # [1] 10
}
}
\seealso{
Other pre_built_prompt_wraps: 
\code{\link{add_image}()},
\code{\link{add_text}()},
\code{\link{answer_as_boolean}()},
\code{\link{answer_as_category}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_list}()},
\code{\link{answer_as_multi_category}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_regex_match}()},
\code{\link{answer_as_text}()},
\code{\link{answer_by_chain_of_thought}()},
\code{\link{answer_by_react}()},
\code{\link{answer_using_r}()},
\code{\link{answer_using_sql}()},
\code{\link{answer_using_tools}()},
\code{\link{prompt_wrap}()},
\code{\link{quit_if}()},
\code{\link{set_system_prompt}()}

Other answer_as_prompt_wraps: 
\code{\link{answer_as_boolean}()},
\code{\link{answer_as_category}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_list}()},
\code{\link{answer_as_multi_category}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_regex_match}()},
\code{\link{answer_as_text}()}
}
\concept{answer_as_prompt_wraps}
\concept{pre_built_prompt_wraps}
