% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windows_pairwise_pop_fst.R
\name{windows_pairwise_pop_fst}
\alias{windows_pairwise_pop_fst}
\title{Compute pairwise Fst for a sliding window}
\usage{
windows_pairwise_pop_fst(
  .x,
  type = c("matrix", "tidy"),
  method = c("Hudson", "Nei87", "WC84"),
  window_size,
  step_size,
  size_unit = c("snp", "bp"),
  min_loci = 1,
  complete = FALSE
)
}
\arguments{
\item{.x}{a grouped \code{gen_tibble} object}

\item{type}{type of object to return. One of "matrix" or "tidy". Default is
"matrix". "matrix" returns a dataframe where each row is a window, followed
by columns of Fst values for each pairwise population a and b comparison.
"tidy" returns a tidy tibble of the same data in 'long' format, where each
row is one window for one pairwise population a and b comparison.}

\item{method}{the method to use for calculating Fst, one of 'Hudson',
'Nei87', and 'WC84'. See \code{\link[=pairwise_pop_fst]{pairwise_pop_fst()}} for details.}

\item{window_size}{The size of the window to use for the estimates.}

\item{step_size}{The step size to use for the windows.}

\item{size_unit}{Either "snp" or "bp". If "snp", the window size and step
size are in number of SNPs. If "bp", the window size and step size are in
base pairs.}

\item{min_loci}{The minimum number of loci required to calculate a window
statistic. If the number of loci in a window is less than this, the window
statistic will be NA.}

\item{complete}{Should the function be evaluated on complete windows only? If
FALSE, the default, then partial computations will be allowed at the end of
the chromosome.}
}
\value{
either a data frame with the following columns:
\itemize{
\item \code{chromosome}: the chromosome for the window
\item \code{start}: the starting locus of the window
\item \code{end}: the ending locus of the window
\item \code{fst_a.b}: the pairwise Fst value for the population a and b (there will be
multiple such columns if there are more than two populations) or a tidy
tibble with the following columns:
\item \code{chromosome}: the chromosome for the window
\item \code{start}: the starting locus of the window
\item \code{end}: the ending locus of the window
\item \code{stat_name}: the name of population a and b used in the pairwise Fst
calculation (e.g. "fst_pop1.pop2")
\item \code{value}: the pairwise Fst value for the population a and b
}
}
\description{
This function computes pairwise Fst for a sliding window across
each chromosome.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

example_gt \%>\%
  group_by(population) \%>\%
  windows_pairwise_pop_fst(
    window_size = 3, step_size = 2,
    size_unit = "snp", min_loci = 2
  )

}
