% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_data_matrix.R
\name{nested_data}
\alias{nested_data}
\alias{unnested_data}
\title{Prepare a parameter-long data frame for statistical analysis}
\usage{
nested_data(
  .data,
  qualifiers = NULL,
  key = NULL,
  value,
  fill = NA,
  select_if = ~TRUE,
  filter_all = any_vars(TRUE),
  trans = identity,
  groups = NULL
)

unnested_data(.data, ...)
}
\arguments{
\item{.data}{Data in parameter-long form}

\item{qualifiers}{Columns that add context to observations (e.g., depth, zone, core)}

\item{key}{The column name that contains the column names of the data matrix}

\item{value}{The column name that contains the values}

\item{fill}{If a key/value combination doesn't exist in the input, this value will be
assigned in the data matrix. Generally, using NA for geochemical data and 0 for relative
abundance data is advised.}

\item{select_if}{Use \code{~TRUE} to keep all columns; use \code{~all(is.finite(.))} to keep columns
with all finite values. See \link[dplyr:select_all]{select_if}.}

\item{filter_all}{Use \code{any_vars(TRUE)} to keep all observations; use \code{all_vars(is.finite(.))} to
keep only observations with finite (non-missing) values. See \link[dplyr:filter_all]{filter_all}.}

\item{trans}{A function that will be applied to all columns, column-wise. Use \link[base:identity]{identity}
to perform no transformation, use \link[base:scale]{scale} to scale each column to a mean of zero and
variance of 1. See \link[dplyr:mutate_all]{mutate_all}.}

\item{groups}{Use \link[dplyr:group_by]{group_by} or this argument to group by one or more columns (e.g., core or lake)}

\item{...}{One or more columns to unnest.}
}
\value{
A nested data matrix, which is composed of a \code{\link[tibble:tibble]{tibble::tibble()}}
with tibble list-columns \code{data}, \code{discarded_rows}, \code{discarded_columns}, and
\code{qualifiers}.
}
\description{
Prepare a parameter-long data frame for statistical analysis
}
\examples{
nested_data(
  alta_lake_geochem,
  qualifiers = c(age, depth, zone),
  key = param,
  value = value,
  trans = scale
)

}
