% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct.R
\name{idct_accel}
\alias{idct_accel}
\title{Inverse Discrete Cosine Transform Acceleration}
\usage{
idct_accel(y, n = length(y))
}
\arguments{
\item{y}{DCT coefficients}

\item{n}{The desired length of the idct}
}
\value{
A vector with the second derivative
of the inverse DCT
}
\description{
The second derivative of the Inverse DCT
}
\details{
Returns the second derivative (acceleration) of
the Inverse DCT (see \link{dct} for more details).

\deqn{
\frac{\delta^2 x_j}{\delta j^2} = -2\left(\frac{\pi k}{J}\right)^2\sum_{k=1}^{N-1} y_k \cos\left(\frac{\pi k(2j+1)}{2J}\right)
}
}
\examples{
x <- seq(0, 1, length = 10)
y <- 5 + x + (2 * (x^2)) + (-2 * (x^4))

dct_coefs <- dct(y)
y_accel <- idct_accel(dct_coefs)

plot(y)
plot(y_accel)

}
