% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/privacy_budget.R
\name{check_privacy_budget}
\alias{check_privacy_budget}
\title{Check Privacy Budget}
\usage{
check_privacy_budget(budget, epsilon_required, delta_required = 0)
}
\arguments{
\item{budget}{A privacy budget object}

\item{epsilon_required}{Epsilon required for the operation}

\item{delta_required}{Delta required for the operation (default: 0)}
}
\value{
Logical indicating if budget is sufficient
}
\description{
Checks if a proposed operation would exceed the privacy budget
}
\examples{
budget <- new_privacy_budget(epsilon_total = 1.0)
check_privacy_budget(budget, epsilon_required = 0.5)
}
