% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_ucarima.R, R/um.R
\name{wkfilter.as_ucarima}
\alias{wkfilter.as_ucarima}
\alias{wkfilter}
\alias{wkfilter.um}
\title{Wiener-Kolmogorov filter}
\usage{
\method{wkfilter}{as_ucarima}(object, z = NULL, tol = 1e-05, envir = parent.frame(), ...)

wkfilter(object, ...)

\method{wkfilter}{um}(
  object,
  um.uc,
  z = NULL,
  output = c("series", "filter"),
  tol = 1e-05,
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{object}{an object of class \code{\link{um}}.}

\item{z}{an optional \code{ts} object. If \code{NULL}, the time series to be
filtered is contained in the \code{um.z} object.}

\item{tol}{numeric tolerance used in polynomial divisions. Default is
\code{1e-5}.}

\item{envir}{environment to get \code{z} when not provided.}

\item{...}{additional arguments.}

\item{um.uc}{ARIMA models for the observed time series and the
unobserved component (signal).}

\item{output}{character, output of the function: `"series"` (default) returns
the filtered time series, or `"filter"` returns the filter coefficients.}
}
\value{
An object of class \code{ts} containing the estimated signal.
}
\description{
\code{wkfilter} extracts a signal for a time series described by an ARIMA
model given the ARIMA model for the signal.
}
\examples{
um1 <- airline(AirPassengers, bc = TRUE)
uca1 <- as.ucarima(um1, i = "(1-B)2")
trend <- wkfilter(um1, uca1$ucm$signal1)
seas <- wkfilter(um1, uca1$ucm$signal2)
}
