% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R
\name{ucm}
\alias{ucm}
\title{Unobserved Components Time Series Models}
\usage{
ucm(
  z,
  bc = FALSE,
  uc = NULL,
  xreg = NULL,
  cform = TRUE,
  fit = TRUE,
  s = 12,
  ...
)
}
\arguments{
\item{z}{an object of class \code{ts}.}

\item{bc}{logical. If TRUE, logs are taken.}

\item{uc}{list of objects of class \code{\link{uc}} or a character with
the name of a predefined model: "llm" local linear model, "lltm" local
linear trend model, "bsm" basic structural model, "bsmd" basic structural
model with dummy seasonality.}

\item{xreg}{optional design matrix of regressors.}

\item{cform}{logical. If TRUE, observation equation is given in 
contemporaneous form (j = 0); otherwise it is written in lagged form (j = 1).}

\item{fit}{logical. If TRUE, model is fitted.}

\item{s}{integer, seasonal period. Optional argument to create a UC model
without providing a time series.}

\item{...}{additional parameters for the \code{\link{fit.ssm}} function.}
}
\value{
An object of class \link{ucm} and class \code{\link{ssm}}.
}
\description{
\code{ucm} creates an S3 object representing an UC model:
}
\details{
z(t) = b'*x(t) + T(t - j) + S(t - j) + C(t - j) + AR(t - j) + I(t),

where z(t) is a time series; x(t) is a set of regressors; T(t - j), S(t - j),
C(t - j), AR(t - j) and I(t) are the trend, seasonal, cycle, autoregressive
and irregular unobserved components; and i indicates whether the model is 
written in lagged form (j = 1) or contemporaneous form (j = 0). 
See \code{\link{uc}} and \code{\link{ssm}} for more details.
}
\examples{
# Local level model
ucm1 <- ucm(Nile, uc = "llm")
ucm1

}
\references{
Durbin, J. and Koopman, S.J. (2012) Time Series Analysis by State Space
Methods, 2nd ed., Oxford University Press, Oxford.

Harvey, A.C. (1989) Forecasting, Structural Time Series Models and the Kalman
Filter. Cambridge University Press, Cambridge.
}
