% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R
\name{predict.tfm}
\alias{predict.tfm}
\title{Forecast Transfer Function Model}
\usage{
\method{predict}{tfm}(
  object,
  newdata = NULL,
  y = NULL,
  ori = NULL,
  n.ahead = NULL,
  level = 0.95,
  i = NULL,
  envir = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted \code{tfm} object.}

\item{newdata}{Optional matrix or vector of future values for exogenous
regressors and inputs. Rows correspond to forecast horizon, columns to
predictors.}

\item{y}{Optional \code{ts} object for alternative output series.}

\item{ori}{Forecast origin (observation index). Default is last observation.}

\item{n.ahead}{Number of steps ahead to forecast. Default is series frequency.}

\item{level}{Confidence level(s) for prediction intervals (0-1). Default is 0.95.
Can be a vector for multiple intervals.}

\item{i}{Optional differencing operator (lagpol) to apply before forecasting.}

\item{envir}{Environment for evaluation. NULL uses calling environment.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Object of class \code{predict.tfm} containing:
\item{z}{Complete series including forecasts}
\item{rmse}{Root mean square error for each forecast}
\item{low, upp}{Lower and upper prediction interval bounds (matrices)}
\item{level}{Confidence level(s) used}
\item{dates}{Time points for all observations}
\item{ori, ori.date}{Forecast origin (index and date)}
\item{n.ahead}{Number of forecasts}
}
\description{
Computes point forecasts and prediction intervals for transfer function models.
}
\details{
Future values for transfer function inputs can be provided in three ways:
(1) extending input series beyond output length, (2) automatic forecasting
from associated \code{um} models, or (3) via the \code{newdata} argument.

If Box-Cox transformation was used, forecasts are back-transformed and
intervals adjusted accordingly.
}
\seealso{
\code{\link{tfm}}, \code{\link{fit.tfm}}
}
