% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/td.output.R
\name{predict.td}
\alias{predict.td}
\title{Predict Method for Temporal Disaggregation}
\usage{
\method{predict}{td}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"td"}, usually, a result of a
call to \code{\link[=td]{td()}}.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
\code{summary.td} returns a vector or a \code{"ts"} object,
containing the disaggregated or interpolated high frequency series of a
temporal disaggregation.
}
\description{
Compute the disaggregated or interpolated (and extrapolated) high frequency
series of a temporal disaggregation.
}
\examples{
data(swisspharma)

mod1 <- td(sales.a ~ imports.q + exports.q)
predict(mod1)
}
\seealso{
\code{\link[=td]{td()}} for the main function for temporal disaggregation.
}
\keyword{models}
\keyword{ts}
