% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_tests.R
\name{weighted_rayleigh}
\alias{weighted_rayleigh}
\title{Weighted Goodness-of-fit Test for Circular Data}
\usage{
weighted_rayleigh(x, mu = NULL, w = NULL, axial = TRUE, quiet = FALSE)
}
\arguments{
\item{x}{numeric vector. Values in degrees}

\item{mu}{The \emph{a priori} expected direction (in degrees) for the alternative
hypothesis.}

\item{w}{numeric vector weights of length \code{length(x)}. If \code{NULL}, the
non-weighted Rayleigh test is performed.}

\item{axial}{logical. Whether the data are axial, i.e. \eqn{\pi}-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{quiet}{logical. Prints the test's decision.}
}
\value{
a list with the components:
\describe{
\item{\code{R} or \code{C}}{mean resultant length or the dispersion (if \code{mu} is
specified). Small values of \code{R} (large values of \code{C}) will reject
uniformity. Negative values of \code{C} indicate that vectors point in opposite
directions (also lead to rejection).}
\item{\code{statistic}}{Test statistic}
\item{\code{p.value}}{significance level of the test statistic}
}
}
\description{
Weighted version of the Rayleigh test (or V0-test) for uniformity against a
distribution with a priori expected von Mises concentration.
}
\details{
The Null hypothesis is uniformity (randomness). The alternative is a
distribution with a (specified) mean direction (\code{mu}).
If \code{statistic >= p.value}, the null hypothesis of randomness is rejected and
angles derive from a distribution with a (or the specified) mean direction.
}
\examples{
# Load data
data("cpm_models")
data(san_andreas)
PoR <- equivalent_rotation(cpm_models[["NNR-MORVEL56"]], "na", "pa")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
data("iceland")
PoR.ice <- equivalent_rotation(cpm_models[["NNR-MORVEL56"]], "eu", "na")
ice.por <- PoR_shmax(iceland, PoR.ice, "out")
data("tibet")
PoR.tib <- equivalent_rotation(cpm_models[["NNR-MORVEL56"]], "eu", "in")
tibet.por <- PoR_shmax(tibet, PoR.tib, "in")

# GOF test:
weighted_rayleigh(tibet.por$azi.PoR, mu = 90, w = 1 / tibet$unc)
weighted_rayleigh(ice.por$azi.PoR, mu = 0, w = 1 / iceland$unc)
weighted_rayleigh(sa.por$azi.PoR, mu = 135, w = 1 / san_andreas$unc)
}
\seealso{
\code{\link[=rayleigh_test]{rayleigh_test()}}
}
