app_driver_tm_t_crosstable <- function() {
  data <- simple_cdisc_data()
  init_teal_app_driver(
    teal::init(
      data = data,
      modules = tm_t_crosstable(
        label = "Cross Table",
        x = teal.transform::data_extract_spec(
          dataname = "ADSL",
          select = teal.transform::select_spec(
            label = "Select variable:",
            choices = teal.transform::variable_choices(data[["ADSL"]], subset = function(data) {
              idx <- !vapply(data, inherits, logical(1), c("Date", "POSIXct", "POSIXlt"))
              names(data)[idx]
            }),
            selected = "COUNTRY",
            multiple = TRUE,
            ordered = TRUE,
            fixed = FALSE
          )
        ),
        y = teal.transform::data_extract_spec(
          dataname = "ADSL",
          select = teal.transform::select_spec(
            label = "Select variable:",
            choices = teal.transform::variable_choices(data[["ADSL"]], subset = function(data) {
              idx <- vapply(data, is.factor, logical(1))
              names(data)[idx]
            }),
            selected = "SEX",
            multiple = FALSE,
            fixed = FALSE
          )
        ),
        show_percentage = TRUE,
        show_total = TRUE,
        pre_output = NULL,
        post_output = NULL,
        basic_table_args = teal.widgets::basic_table_args(
          subtitles = "Table generated by Crosstable Module"
        )
      )
    ),
    timeout = 10000
  )
}

test_that("e2e - tm_t_crosstable: Initializes without errors", {
  skip_if_too_deep(5)
  app_driver <- app_driver_tm_t_crosstable()

  app_driver$expect_no_shiny_error()

  testthat::expect_equal(app_driver$get_text(".teal-modules-tree .active"), "Cross Table")

  encoding_dataset <- app_driver$get_text(paste(app_driver$namespaces(TRUE)$wrapper(NULL), ".help-block"))
  testthat::expect_match(encoding_dataset, "Dataset:\\n *ADSL\\n", all = FALSE)

  app_driver$stop()
})

test_that("e2e - tm_t_crosstable: Verify module displays data table", {
  skip_if_too_deep(5)
  app_driver <- app_driver_tm_t_crosstable()

  # table
  testthat::expect_true(
    app_driver$is_visible(selector = app_driver$namespaces(TRUE)$module("table-table-with-settings"))
  )

  app_driver$stop()
})

test_that("e2e - tm_t_crosstable: Verify default values and settings (data_extracts) for data selection", {
  skip_if_too_deep(5)
  app_driver <- app_driver_tm_t_crosstable()

  # default variable selection
  testthat::expect_equal(
    app_driver$get_active_module_input("x-dataset_ADSL_singleextract-select"),
    "COUNTRY"
  )

  testthat::expect_equal(
    app_driver$get_active_module_input("y-dataset_ADSL_singleextract-select"),
    "SEX"
  )

  # new variable selection
  app_driver$set_active_module_input("x-dataset_ADSL_singleextract-select", c("SEX", "RACE", "COUNTRY"))
  app_driver$set_active_module_input("y-dataset_ADSL_singleextract-select", "ETHNIC")
  app_driver$expect_no_validation_error()

  app_driver$stop()
})

test_that("e2e - tm_t_crosstable: Change plot settings", {
  skip_if_too_deep(5)
  app_driver <- app_driver_tm_t_crosstable()

  app_driver$click(selector = app_driver$namespaces(TRUE)$module("show_percentage"))
  app_driver$expect_no_validation_error()

  app_driver$click(selector = app_driver$namespaces(TRUE)$module("show_total"))
  app_driver$expect_no_validation_error()

  app_driver$stop()
})
