% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_logger.R
\name{register_logger}
\alias{register_logger}
\title{Registers a logger instance in a given logging namespace.}
\usage{
register_logger(namespace = NA_character_, layout = NULL, level = NULL)
}
\arguments{
\item{namespace}{(\code{character(1)} or \code{NA_character_})\cr
the name of the logging namespace}

\item{layout}{(\code{character(1)})\cr
the log layout. Alongside the standard logging variables provided by the \code{logging} package
(e.g. \code{pid}) the \code{token} variable can be used which will write the last 8 characters of the
shiny session token to the log.}

\item{level}{(\code{character(1)} or \code{call}) the log level. Can be passed as
character or one of the \code{logger}'s objects.
See \code{\link[logger:log_threshold]{logger::log_threshold()}} for more information.}
}
\value{
\code{invisible(NULL)}
}
\description{
Registers logger instance.
}
\details{
Creates a new logging namespace specified by the \code{namespace} argument.
When the \code{layout} and \code{level} arguments are set to \code{NULL} (default), the function
gets the values for them from system variables or R options.
When deciding what to use (either argument, an R option or system variable), the function
picks the first non \code{NULL} value, checking in order:
\enumerate{
\item Function argument.
\item System variable.
\item R option.
}

\code{layout} and \code{level} can be set as system environment variables, respectively:
\itemize{
\item \code{teal.log_layout} as \code{TEAL.LOG_LAYOUT},
\item \code{teal.log_level} as \code{TEAL.LOG_LEVEL}.
}

If neither the argument nor the environment variable is set the function uses the following R options:
\itemize{
\item \code{options(teal.log_layout)}, which is passed to \code{\link[logger:layout_glue_generator]{logger::layout_glue_generator()}},
\item \code{options(teal.log_level)}, which is passed to \code{\link[logger:log_threshold]{logger::log_threshold()}}
}

The logs are output to \code{stdout} by default. Check \code{logger} for more information
about layouts and how to use \code{logger}.
}
\note{
It's a thin wrapper around the \code{logger} package.
}
\examples{
options(teal.log_layout = "{msg}")
options(teal.log_level = "ERROR")
register_logger(namespace = "new_namespace")
\donttest{
logger::log_info("Hello from new_namespace", namespace = "new_namespace")
}

}
\seealso{
The package vignettes for more help: \code{browseVignettes("teal.logger")}.
}
