% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcl_scorefun.R
\name{tcl_scorefun}
\alias{tcl_scorefun}
\title{Computation of score function.}
\usage{
tcl_scorefun(data, eta, W, model = "RM")
}
\arguments{
\item{data}{data matrix.}

\item{eta}{numeric vector of item easiness parameters.}

\item{W}{design matrix.}

\item{model}{RM, PCM, RSM, LLTM. Default is set to "RM".}
}
\value{
Score function evaluated at eta.
}
\description{
Uses function \code{jacobian()} from numDeriv package to compute (approximate numerically) score function
  (first order partial derivatives of conditional log likelihood function)
  evaluated at arbitrary values of item easiness parameters.
}
\examples{
\dontrun{
# Rasch model with beta_1 restricted to 0
y <- eRm::raschdat1
res <- eRm::RM(X = y, sum0 = FALSE)
scorefun <- tcl_scorefun(data = y, eta = res$etapar, model = "RM")
}
}
\references{
{
Gilbert, P., Gilbert, M. P., & Varadhan, R. (2016). numDeriv: Accurate Numerical Derivatives. R package
version 2016.8-1.1. url: https://CRAN.R-project.org/package=numDeriv
 }
}
\keyword{htest}
