% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depreciation_interest.R
\name{depreciation_interest}
\alias{depreciation_interest}
\title{Annual depreciation + interest for medical equipment}
\usage{
depreciation_interest(
  v_replace_val,
  r_salvage_val,
  n_amortisation_period = 10,
  i_interest_rt = 0.025,
  output = c("dataframe", "annuity_factor", "annual_cost")
)
}
\arguments{
\item{v_replace_val}{V: vervangingswaarde; replacement value (numeric scalar, > 0)}

\item{r_salvage_val}{R: restwaarde; salvage (residual) value at end of period (numeric scalar, >= 0)}

\item{n_amortisation_period}{n: afschrijvingstermijn; amortisation period in years (numeric scalar, > 0)}

\item{i_interest_rt}{i: rentepercntage; annual interest rate as a decimal (numeric scalar, >= 0)}

\item{output}{One of \code{dataframe} (default), \code{annuity_factor}, or \code{annual_cost}.}
}
\value{
\itemize{
\item If \code{output = "dataframe"}: a data.frame with two columns:
\verb{Annuity factor} and \verb{Yearly depreciation and interest costs}.
\item If \code{output = "annuity_factor"}: a single numeric (the annuity factor).
\item If \code{output = "annual_cost"}: a single numeric (the annual charge k).
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Compute the annuity factor and the annual depreciation-and-interest charge for medical equipment, following Section 7.3 of the Dutch costing manual; k = annual depreciation and interest expense jaarlijkse afschrijvings- en rentekosten

Let V be replacement value, R the salvage value, n the amortisation period (years), and i the interest rate (per year). The annuity factor is:
\deqn{a_{n,i} = \frac{1}{i}*\bigg(1-\frac{1}{(1 + i)^{n}}\bigg)}
#'
The annual charge k is:
\deqn{k = \frac{V - \frac{R}{(1 + i)^n}}{a_{n,i}}}
}
\examples{
# Both values as a data frame (defaults: n=10, i=2.5\%)
depreciation_interest(v_replace_val = 50000, r_salvage_val = 5000)

# Only the annuity factor
depreciation_interest(50000, 5000, output = "annuity_factor")

# Only the annual charge (k)
depreciation_interest(50000, 5000, output = "annual_cost")

# Zero interest (uses the i -> 0 limit): a = n, k = (V - R)/n
depreciation_interest(50000, 5000, n_amortisation_period = 8,
                      i_interest_rt = 0,
                      output = "dataframe")

}
\keyword{Generic}
\keyword{costs}
\keyword{equipment}
