% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary_functions.R
\name{compare_modification_times}
\alias{compare_modification_times}
\title{Compare modification times of two files and determine synchronization status}
\usage{
compare_modification_times(modification_time_left, modification_time_right)
}
\arguments{
\item{modification_time_left}{modification time of the file in the left directory}

\item{modification_time_right}{modification time of the file in the right directory}
}
\value{
A list containing the following components:
\item{is_new_left}{Logical. Indicates if the file in the left directory is newer
(i.e., has a later modification time) than the file in the right directory}
\item{is_new_right}{Logical. Indicates if the file in the right directory is newer
(i.e., has a later modification time) than the file in the left directory}
\item{sync_status_date}{Character. Describes the synchronization status between the
two files based on their modification times:
- "newer in left, older in right dir": Left file is newer than right file.
- "older in left, newer in right dir": Right file is newer than left file.
- "same date": Both files have the same modification time.}
}
\description{
This function compares the date of last modification of two files and determines
their synchronization status
}
\keyword{internal}
