% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{sd_output}
\alias{sd_output}
\title{Output Function for Displaying reactive objects and values}
\usage{
sd_output(
  id,
  type = NULL,
  width = "100\%",
  display = "text",
  inline = TRUE,
  wrapper = NULL,
  ...
)
}
\arguments{
\item{id}{Character string. A unique identifier for the output element.}

\item{type}{Character string. Specifies the type of output corresponding
with the question \code{id}. Can be \code{"question"}, \code{"value"}, \code{"label_option"},
\code{"label_question"}, or \code{NULL.} If \code{"question"}, it will display a
question defined in the server. If \code{"value"}, it will display the value
of question \code{id} selected by the respondent. If \code{"label_option"}, it will
display the label of the option for question \code{id} selected by the
respondent. If \code{"label_question"}, it will display the \code{label} argument
value for question \code{id}. Finally, if \code{NULL}, the function behaves like
\code{shiny::uiOutput()}.}

\item{width}{Character string. The width of the UI element. Defaults to
\code{"100\%"}.}

\item{display}{Character string. Specifies the display type for \code{"value"}
outputs. Can be \code{"text"}, \code{"verbatim"}, or \code{"ui"}. Only used when
\code{type = "value"}.}

\item{inline}{Logical. Whether to render the output inline. Defaults to
\code{TRUE}.}

\item{wrapper}{Function. A function to wrap the output. Only used when
\code{type = "value"}.}

\item{...}{Additional arguments passed to the underlying 'shiny' functions
or the wrapper function.}
}
\value{
A 'shiny' UI element, the type of which depends on the input
parameters.
}
\description{
Output Function for Displaying reactive objects and values
}
\details{
The function behaves differently based on the \code{type} parameter:
\itemize{
\item If \code{type} is \code{NULL}, it acts like \code{shiny::uiOutput()}.
\item If \code{type} is \code{"question"}, it creates a placeholder for a reactive survey question.
\item If \code{type} is \code{"value"}, it creates an output to display the value of a survey question,
with the display style determined by the \code{display} parameter.
}
}
\examples{
if (interactive()) {
  library(surveydown)

  # Use sd_output() to display reactive questions or values:
  # First, define something in server of app.R:
  # server <- function(input, output, session) {
  #   completion_code <- sd_completion_code(10)
  #   sd_store_value(completion_code)
  #   sd_server()
  # }

  # Then, display in R chunks of survey.qmd:
  # Your code is: `r sd_output("completion_code", type = 'value')`

  # Find a working directory and start from a template:
  sd_create_survey(template = "reactive_questions")
  # This creates survey.qmd and app.R - launch the survey using app.R
}

}
