% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterSTOICH.R
\name{filterSTOICH}
\alias{filterSTOICH}
\title{Filter Data in the STOICH Data Tables}
\usage{
filterSTOICH(dataTables, var, val, condition)
}
\arguments{
\item{dataTables}{The STOICH data tables loaded using loadSTOICH.}

\item{var}{The STOICH variable to filter. Use View(stoichData$metadata) to see a table of all variables and their descriptions
(assumes data was loaded into the variable "stoichData"). The variable can be either the joined variable name (including the table name)
"SampleDate.SampleEvent" or the prejoin name "SampleDate". The joined variable name will be required for multiple variables with the same
name (such as "Notes").}

\item{val}{The value or value range for the variable you want to filter.
The conditions "greater than" and "less than" only work with a single numeric or date value, while "equal" and "not equal" work with
a single value or an array of values (text, numeric or date). The "range" condition requires an array of 2 numeric or date values.}

\item{condition}{The criteria used for filtering (greater than, less than, equal, not equal, range, etc.). See the val parameter for
the possible inputs for each condition.}
}
\value{
The STOICH data tables after filtering has been applied.
}
\description{
Filters the STOICH data from release files based on selected criteria.
}
\examples{
\dontrun{
# Load the data
stoichData <- loadSTOICH(dataPath="C:/Users/example_user/STOICH_data_location")

# filtering by table such as:
stoichFiltered <- filterSTOICH(dataTables=stoichData,
                               var="TrophicMode",
                               val="photoautotroph",
                               condition="equal")
stoichFiltered <- filterSTOICH(dataTables=stoichData,
                               var="Latitude",
                               val=c(54.1, 103.1),
                               condition="range")
stoichFiltered <- filterSTOICH(dataTables=stoichData,
                               var="Type.OrganismStoichiometry",
                               val="seston",
                               condition="equal")
stoichFiltered <- filterSTOICH(dataTables=stoichData,
                               var="Name",
                               val=c("Suggs", "Barco"),
                               condition="contains")

stoichTable <- joinSTOICH(stoichFiltered)

}

}
\author{
Chad Petersen \email{cpetersen4@unl.edu}
}
