% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.test.cor}
\alias{size.test.cor}
\title{Sample size for a test of a Pearson or partial correlation}
\usage{
size.test.cor(alpha, pow, cor, s, h)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{cor}{planning value of correlation}

\item{s}{number of control variables}

\item{h}{null hypothesis value of correlation}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to test a population Pearson or a partial
correlation with desired power. Set s = 0 for a Pearson correlation.

For more details, see Section 1.25 of Bonett (2021, Volume 2)
}
\examples{
size.test.cor(.05, .95, -.50, 0, 0)

# Should return:
# Sample size
#          47

size.test.cor(.05, .90, .4, 2, 0)

# Should return:
# Sample size
#          64
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
