% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.pv}
\alias{ci.pv}
\title{Confidence intervals for positive and negative predictive values with
retrospective sampling}
\usage{
ci.pv(alpha, f1, f2, n1, n2, prev)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{number of participants with a positive outcome who pass the test}

\item{f2}{number of participants with a negative outcome who fail the test}

\item{n1}{sample size for the positive outcome group}

\item{n2}{sample size for the negative outcome group}

\item{prev}{known population proportion with a positive outcome}
}
\value{
Returns a 2-row matrix. The columns are:
\itemize{
\item Estimate - adjusted estimate of the predictive value
\item LL - lower limit of the adjusted Wald confidence interval
\item UL - upper limit of the adjusted Wald confidence interval
}
}
\description{
Computes adjusted Wald confidence intervals for positive and negative
predictive values (PPV and NPV) of a diagnostic test with retrospective
sampling where the population prevalence rate is assumed to be known. With
retrospective sampling, one random sample is obtained from a subpopulation
that is known to have a "positive" outcome, a second random sample is
obtained from a subpopulation that is known to have a "negative" outcome,
and then the diagnostic test (scored "pass" or "fail") is given in each
sample. PPV and NPV can be expressed as a function of proportion ratios
and the known population prevalence rate (the population proportion who
would "pass"). The confidence intervals for PPV and NPV are based on the
Price-Bonett adjusted Wald confidence interval for a proportion ratio.

For more details, see Section 3.6 of Bonett (2021, Volume 3)
}
\examples{
ci.pv(.05, 89, 5, 100, 100, .16)

# Should return:
#        Estimate        LL        UL
# PPV:  0.7640449 0.5838940 0.8819671
# NPV:  0.9779978 0.9623406 0.9872318


}
\references{
\insertRef{Price2008}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
