% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_statis_dual.R
\name{plot.statis.dual.circle}
\alias{plot.statis.dual.circle}
\title{Bivariate PCA-style Scatter Plot}
\usage{
\method{plot}{statis.dual.circle}(
  points.list,
  style.points = list(list(size = 3)),
  style.circle = list(),
  radius.circle = 1,
  labels = "auto",
  labels.style = NULL,
  draw.labels = TRUE,
  vars.direction = NULL,
  style.vars = list(),
  radius.vars = c(0.5, 1),
  join.dots = FALSE,
  style.join = list(),
  base.colors = .base.colors,
  axes = TRUE,
  frame = TRUE,
  hide.ticks = TRUE,
  proportion = 1,
  xlim = NULL,
  ylim = NULL,
  axes.xy = TRUE,
  style.axes.xy = list(linewidth = 0.35, linetype = "dashed", color = "gray40"),
  arrows.points = TRUE,
  factor.arrow = 0.95,
  style.arrows = list(color = "red", linewidth = 0.6, arrow = grid::arrow(length =
    grid::unit(0.2, "cm")))
)
}
\arguments{
\item{points.list}{List of numeric objects (matrices, data.frames, or lists of vectors), each representing a group of 2D points.}

\item{style.points}{List of \code{ggplot2} styles applied per group. If \code{NULL}, \code{geom_point()} is used by default.}

\item{style.circle}{List of styles for the reference circle (passed to \code{ggforce::geom_circle}).}

\item{radius.circle}{Radius (or vector of radii) to draw circles centered at the origin. Default value \code{1}, if \code{0}, no circles are drawn.}

\item{labels}{\code{"auto"} generates numeric labels by group, or it can be a vector/list of custom labels.}

\item{labels.style}{List of styles for the labels, passed to \code{ggrepel::geom_text_repel}.}

\item{draw.labels}{Logical. If \code{TRUE}, labels are drawn on the points.}

\item{vars.direction}{Directions of projected variables.}

\item{style.vars}{Style for projected variables.}

\item{radius.vars}{Radii used to scale variable arrows.}

\item{join.dots}{Logical or list. If \code{TRUE}, connects points by group. If a list, connects points as manually defined.}

\item{style.join}{List of styles for connecting points (passed to \code{geom_path()}).}

\item{base.colors}{Vector of base colors used for the groups.}

\item{axes}{Logical. If \code{FALSE}, all axis elements are removed.}

\item{frame}{Logical. Not directly used; may be reserved for future use.}

\item{hide.ticks}{Logical. If \code{TRUE}, hides axis ticks and text.}

\item{proportion}{Fixed aspect ratio of the plot (to avoid distortion).}

\item{xlim}{X-axis limits.}

\item{ylim}{Y-axis limits.}

\item{axes.xy}{Logical. If \code{TRUE}, draws cross axes (X = 0, Y = 0) with defined style.}

\item{style.axes.xy}{List of styles for the XY cross axes (e.g., \code{linetype}, \code{color}, etc.).}

\item{arrows.points}{Logical. If \code{TRUE}, draws arrows from the origin to each point.}

\item{factor.arrow}{Factor to shorten the arrows.}

\item{style.arrows}{List of styles for the arrows.}
}
\value{
A \code{ggplot} object with the generated plot.
}
\description{
This function generates a 2D scatter plot with support for multiple groups,
labels, arrows from the origin, reference circles, cross axes, and full style customization using \code{ggplot2}.
}
\examples{
data(Tuis5_95, Tuis5_96, Tuis5_97, Tuis5_98)
labels <- c("95","96","97","98")

res <- statis.dual(list(Tuis5_95, Tuis5_96, Tuis5_97, Tuis5_98), labels.tables = labels)

# Interstructure
t <- ggplot2::ggtitle("Interstructure")
plot.statis.dual.circle(points.list = list(res$interstructure), labels = res$labels.tables) + t

# Circle of correlations (all variables)
t <- ggplot2::ggtitle("Correlation (all variables)")
plot.statis.dual.circle(list(res$supervariables), labels = row.names(res$supervariables)) + t

# Circle of correlations (variables selected)
selected.variables <- c("Ph", "Temp", "DBO", "ST", "PO4", "NO3", "POD", "Cal")
superv.sel.df <- select.super.variables(res$supervariables, res$vars.names, selected.variables)

t <- ggplot2::ggtitle("Correlation (selected variables)")
plot.statis.dual.circle(list(superv.sel.df), labels = row.names(superv.sel.df)) + t

}
\seealso{
\code{\link{statis.dual}}
}
