% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stations.R
\name{check_station_status}
\alias{check_station_status}
\title{Check status of specific SNIRH stations}
\usage{
check_station_status(station_ids, matrix = "surface.water", timeout = 30)
}
\arguments{
\item{station_ids}{Character vector of station IDs to check.}

\item{matrix}{Character string specifying the matrix type. Currently supports
"surface.water" and "biota". Default is "surface.water".}

\item{timeout}{Numeric. Timeout in seconds for downloading data. Default is 30.}
}
\value{
A data.table with the following columns:
\describe{
\item{station_id}{The station ID that was checked}
\item{found}{Logical indicating if station exists in SNIRH}
\item{status}{Station status if found, NA if not found}
\item{active}{Logical indicating if station is active (status = "ATIVA")}
}
}
\description{
Validates specific station IDs against the SNIRH database and returns
their current status. This is useful for checking stations before
running the full conversion process.
}
\details{
This function is particularly useful for:
\itemize{
\item Pre-validating station IDs before data conversion
\item Checking why certain stations fail validation
\item Getting an overview of station status for reporting
}
}
\examples{
\donttest{
# Check status of specific stations
my_stations <- c("07G/50", "25G/07", "INVALID_ID")
status_check <- check_station_status(my_stations)
print(status_check)

# Check which stations are not active
inactive <- status_check[active == FALSE | is.na(active)]
if (nrow(inactive) > 0) {
  print("Stations requiring attention:")
  print(inactive)
  }

# Check only active stations
active_stations <- status_check[active == TRUE]
}

}
\seealso{
\code{\link{get_snirh_stations}} for getting all station information

\code{\link{convert_to_snirh}} for the main conversion function
}
