% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridge.regression.R
\name{optimize.cv.lambda}
\alias{optimize.cv.lambda}
\title{Optimize Lambda Using Cross-Validation}
\usage{
optimize.cv.lambda(x, y, lambda.range, folds)
}
\arguments{
\item{x}{A standardized design matrix (n × p)}

\item{y}{A centered response vector (n × 1)}

\item{lambda.range}{A numeric vector of length 2 specifying the search interval}

\item{folds}{Number of cross-validation folds}
}
\value{
A list containing:
\describe{
  \item{minimum}{Optimal lambda value}
  \item{objective}{Minimum CV-MSE achieved}
  \item{trace}{Data frame with lambda and CV-MSE pairs}
}
}
\description{
Searches the lambda range to minimize CV-MSE using Brent's method via `optimize()`.
}
\keyword{internal}
