% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_simaerep.R
\name{simaerep}
\alias{simaerep}
\alias{simaerep_inframe}
\alias{simaerep_classic}
\title{Create simaerep object}
\usage{
simaerep(
  df_visit,
  r = 1000,
  check = TRUE,
  under_only = FALSE,
  visit_med75 = FALSE,
  inframe = TRUE,
  progress = TRUE,
  mult_corr = TRUE,
  poisson_test = FALSE,
  env = parent.frame(),
  event_names = c("event"),
  col_names = list(study_id = "study_id", site_id = "site_id", patient_id = "patient_id",
    visit = "visit")
)

simaerep_inframe(
  df_visit,
  r = 1000,
  under_only = FALSE,
  visit_med75 = FALSE,
  check = TRUE,
  env = parent.frame(),
  event_names = c("event"),
  mult_corr = FALSE,
  col_names = list(study_id = "study_id", site_id = "site_id", patient_id = "patient_id",
    visit = "visit")
)

simaerep_classic(
  df_visit,
  check = TRUE,
  progress = TRUE,
  env = parent.frame(),
  under_only = TRUE,
  r = 1000,
  mult_corr = FALSE,
  poisson_test = FALSE,
  event_names = "event",
  col_names = list(study_id = "study_id", site_id = "site_id", patient_id = "patient_id",
    visit = "visit")
)
}
\arguments{
\item{df_visit}{Data frame with columns: study_id, site_number, patnum, visit,
n_ae.}

\item{r}{Integer or tbl_object, number of repetitions for bootstrap
simulation. Pass a tbl object referring to a table with one column and as
many rows as desired repetitions. Default: 1000.}

\item{check}{Logical, perform data check and attempt repair with
\code{\link[=check_df_visit]{check_df_visit()}}. Computationally expensive on large data sets. Default:
TRUE.}

\item{under_only}{Logical, compute under-reporting probabilities only.
only applies to the classic algorithm in which a one-sided evaluation can
save computation time. Default: FALSE}

\item{visit_med75}{Logical, should evaluation point visit_med75 be used. Compatible
with inframe and classic version of the algorithm.
Default: FALSE}

\item{inframe}{Logical, when FALSE classic simaerep algorithm will be used. The
default inframe method uses only table operations and is compatible with
dbplyr supported database backends. Default: TRUE}

\item{progress}{Logical, display progress bar. Default: TRUE.}

\item{mult_corr}{Logical, multiplicity correction, Default: TRUE}

\item{poisson_test}{logical, compute p-value with poisson test, only supported
by the classic algorithm using visit_med75. Default: FALSE}

\item{env}{Optional, provide environment of original visit data. Default:
parent.frame().}

\item{event_names}{vector, contains the event names, default = "event"}

\item{col_names}{named list, indicate study_id, site_id, patient_id and visit
column in df_visit input dataframe. Default: list(
study_id = "study_id",
site_id = "site_id",
patient_id = "patient_id",
visit = "visit"
)}
}
\value{
A simaerep object. Results are contained in the attached df_eval dataframe.\tabular{lll}{
   Column Name \tab Description \tab Type \cr
   study_id \tab The study ID \tab Character \cr
   site_id. \tab The site ID \tab Character \cr
   (event)_count \tab Site event count \tab Numeric \cr
   (event)_per_visit_site \tab Site Ratio of event count divided by visits \tab Numeric \cr
   visits \tab Site visit count \tab Numeric \cr
   n_pat \tab Site patient count \tab Numeric \cr
   (event)_per_visit_study \tab Simulated study ratio \tab Numeric \cr
   (event)_prob \tab Site event ratio probability from -1 to 1 \tab Numeric \cr
   (event)_delta \tab Difference expected vs reported events \tab Numeric \cr
}
}
\description{
Simulate AE under-reporting probabilities.
}
\details{
Executes \code{\link[=site_aggr]{site_aggr()}}, \code{\link[=sim_sites]{sim_sites()}}, and \code{\link[=eval_sites]{eval_sites()}} on original
visit data and stores all intermediate results. Stores lazy reference to
original visit data for facilitated plotting using generic plot(x).
}
\examples{
df_visit <- sim_test_data_study(
  n_pat = 100,
  n_sites = 5,
  ratio_out = 0.4,
  factor_event_rate = - 0.6
)

evrep <- simaerep(df_visit)
evrep
str(evrep)

# simaerep classic algorithm

evrep <- simaerep(df_visit, inframe = FALSE, under_only = TRUE, mult_corr = TRUE)
evrep

# multiple events

df_visit_events_test <- sim_test_data_study(
  n_pat = 100,
  n_sites = 5,
  ratio_out = 0.4,
  factor_event_rate = - 0.6,
  event_rates = list(0.5, 0.3),
  event_names = c("ae", "pd")
)

evsrep <- simaerep(df_visit_events_test, inframe = TRUE, event_names = c("ae", "pd"))

evsrep

\donttest{
# Database example
con <- DBI::dbConnect(duckdb::duckdb(), dbdir = ":memory:")
df_r <- tibble::tibble(rep = seq(1, 1000))
dplyr::copy_to(con, df_visit, "visit")
dplyr::copy_to(con, df_r, "r")
tbl_visit <- dplyr::tbl(con, "visit")
tbl_r <- dplyr::tbl(con, "r")
simaerep(tbl_visit, r = tbl_r)
DBI::dbDisconnect(con)
}
}
\seealso{
\link{site_aggr}, \link{sim_sites},
\link{eval_sites}, \link{orivisit},
\link{plot.simaerep}, \link{print.simaerep},
\link{simaerep_inframe}
}
