% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_test_data.R
\name{sim_out}
\alias{sim_out}
\title{simulate under-reporting}
\usage{
sim_out(df_visit, study_id, site_id, factor_event)
}
\arguments{
\item{df_visit, }{dataframe}

\item{study_id, }{character}

\item{site_id, }{character}

\item{factor_event, }{double, negative values for under-reporting positive for
for over-reporting.}
}
\description{
we remove a fraction of events from a specific site
}
\details{
we determine the absolute number of events per patient for removal.
Then them remove them at the first visit.
We intentionally allow fractions
}
\examples{
df_visit <- sim_test_data_study(n_pat = 100, n_sites = 10)


df_ur <- sim_out(df_visit, "A", site_id = "S0001", factor_event = - 0.35)

# Example cumulated event for first patient with 35\% under-reporting
df_ur[df_ur$site_id == "S0001" & df_ur$patient_id == "P000001",]$n_event

# Example cumulated event for first patient with no under-reporting
df_visit[df_visit$site_id == "S0001" & df_visit$patient_id == "P000001",]$n_event

}
