% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_test_data.R
\name{get_portf_config}
\alias{get_portf_config}
\title{Get Portfolio Configuration}
\usage{
get_portf_config(
  df_visit,
  check = TRUE,
  min_pat_per_study = 100,
  min_sites_per_study = 10,
  anonymize = TRUE,
  pad_width = 4
)
}
\arguments{
\item{df_visit}{input dataframe with columns study_id, site_id, patient_id, visit, n_events.
Can also be a lazy database table.}

\item{check}{logical, perform standard checks on df_visit, Default: TRUE}

\item{min_pat_per_study}{minimum number of patients per study, Default: 100}

\item{min_sites_per_study}{minimum number of sites per study, Default: 10}

\item{anonymize}{logical, Default: TRUE}

\item{pad_width}{padding width for newly created IDs, Default: 4}
}
\value{
dataframe with the following columns: \describe{
\item{\strong{study_id}}{study identification} \item{\strong{event_per_visit_mean}}{mean
event per visit per study} \item{\strong{site_id}}{site}
\item{\strong{max_visit_sd}}{standard deviation of maximum patient visits per
site} \item{\strong{max_visit_mean}}{mean of maximum patient visits per site}
\item{\strong{n_pat}}{number of patients} }
}
\description{
Get Portfolio configuration from a df_visit input dataframe. Will
. filter studies with only a few sites and patients and will anonymize IDs.
. Portfolio configuration can be
used by \code{\link{sim_test_data_portfolio}} to generate data for an
artificial portfolio.
}
\examples{
df_visit1 <- sim_test_data_study(n_pat = 100, n_sites = 10,
                                 ratio_out = 0.4, factor_event_rate = - 0.6,
                                 study_id = "A")


df_visit2 <- sim_test_data_study(n_pat = 100, n_sites = 10,
                                 ratio_out = 0.2, factor_event_rate = - 0.1,
                                 study_id = "B")


df_visit <- dplyr::bind_rows(df_visit1, df_visit2)


get_portf_config(df_visit)

\donttest{
# Database example
con <- DBI::dbConnect(duckdb::duckdb(), dbdir = ":memory:")
dplyr::copy_to(con, df_visit, "visit")
tbl_visit <- dplyr::tbl(con, "visit")
get_portf_config(tbl_visit)
DBI::dbDisconnect(con)
}
}
\seealso{
\code{\link{sim_test_data_study}}
\code{\link{get_portf_config}}
\code{\link{sim_test_data_portfolio}}
}
