% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ProjectToStability}
\alias{ProjectToStability}
\title{Project Matrix to Stability}
\usage{
ProjectToStability(x, margin = 0.98, tol = 1e-12)
}
\arguments{
\item{x}{Numeric square matrix.}

\item{margin}{Double in \eqn{(0, 1)}.
Target upper bound for the spectral
radius (default = 0.98).}

\item{tol}{Small positive double
added to the denominator in the scaling
factor to avoid division by zero
(default \code{1e-12}).}
}
\value{
A numeric matrix of the same dimensions as \code{x},
scaled if necessary to satisfy the stability constraint.
}
\description{
Scales a square matrix
so that its spectral radius
is strictly less than 1 by a specified stability margin.
This is useful for ensuring that transition matrices
in state space or vector autoregressive (VAR) models are stationary.
If the matrix is already within the margin,
it is returned unchanged.
}
\details{
The projection is performed
by multiplying the matrix by a constant factor
\eqn{c = \frac{\text{margin}}{\rho + \text{tol}}},
where \eqn{\rho} is the spectral radius and \code{tol}
is a small positive number to prevent division by zero.
}
\examples{
# Matrix with eigenvalues greater than 1
x <- matrix(
  data = c(
    1.2, 0.3,
    0.4, 0.9
  ),
  nrow = 2
)
SpectralRadius(x = x) # > 1
SpectralRadius(x = ProjectToStability(x = x))  # < 1

# Matrix already stable is returned unchanged
x <- matrix(
  data = c(
    0.5, 0.3,
    0.2, 0.4
  ),
  nrow = 2
)
identical(ProjectToStability(x = x), x)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimBetaNCovariate}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimPhiNCovariate}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{simStateSpace}
\keyword{ssm}
\keyword{stability}
