% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated-funs.R
\name{silv_spacing_index}
\alias{silv_spacing_index}
\title{Hart or Hart-Becking spacing index}
\usage{
silv_spacing_index(h0, ntrees, which = "hart")
}
\arguments{
\item{h0}{Numeric vector with dominant height}

\item{ntrees}{Numeric vector with number of trees of the dominant height per
hectare}

\item{which}{A character with the name of the index (either \code{hart} or \code{hart-brecking}).
See details}
}
\value{
A numeric vector
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Calculates the Hart Index or the Hart-Becking Index for even-aged stands
}
\details{
The spacing index can be used to determine whether a thinning is needed or not,
and also to determine how intense it should be.
\itemize{
\item \bold{Hart Index}: it assumes even-aged stands with square planting pattern.
\item \bold{Hart-Brecking Index}: it assumes triangular planting pattern.
}
}
\examples{
library(dplyr)
## Calculate spacing index for each plot
inventory_samples |>
  summarise(
    h0     = silv_dominant_height(diameter, height),
    ntrees = n(),
    .by    = plot_id
  ) |>
  ## calculate number of trees per hectare
  mutate(ntrees_ha = silv_ntrees_ha(ntrees, plot_size = 14.1)) |>
  mutate(spacing = silv_spacing_index(h0, ntrees_ha))
}
\references{
Assmann, E. (1970) The principles of forest yield study: Studies in the
organic production, structure, increment, and yield of forest stands. Pergamon Press, Oxford.
}
