% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-height.R
\name{silv_predict_height}
\alias{silv_predict_height}
\title{Estimates tree height from DBH}
\usage{
silv_predict_height(diameter, model, quiet = FALSE)
}
\arguments{
\item{diameter}{Numeric vector with diameters in cm}

\item{model}{A function. A function with the structure \code{eq_hd_*()} with
additional arguments depending on the specific model. Currently only \code{\link[=eq_hd_vazquez_veloso_2025]{eq_hd_vazquez_veloso_2025()}}
is available.}

\item{quiet}{A logical value. If TRUE, suppresses any informational messages.}
}
\value{
A numeric vector with predicted heights
}
\description{
Estimates total tree height using height-diameter (h-d) equations. Currently, only models developed
for Spain are available.
}
\details{
The function estimates total tree height (in meters) using diameter at breast height (in centimeters),
and may require additional information depending on the specific model. See each model’s documentation for details.
}
\examples{
1 + 1 #TODO
}
\references{
References for the models available:
\itemize{
\item \strong{\code{\link[=eq_hd_vazquez_veloso_2025]{eq_hd_vazquez_veloso_2025()}}}: Vázquez-Veloso, A., Yang, S.-I., Bullock, B.P., Bravo, F., 2025. One model to rule them all:
A nationwide height–diameter model for 91 Spanish forest species. Forest Ecology and Management 595, 122981.
https://doi.org/10.1016/j.foreco.2025.122981
}
}
\seealso{
\code{\link[=eq_hd_vazquez_veloso_2025]{eq_hd_vazquez_veloso_2025()}}
}
